/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.block.entity.device;

import cofh.core.util.helpers.AugmentDataHelper;
import cofh.lib.api.StorageGroup;
import cofh.lib.fluid.FluidStorageCoFH;
import cofh.lib.inventory.ItemStorageCoFH;
import cofh.thermal.core.config.ThermalCoreConfig;
import cofh.thermal.core.init.TCoreTileEntities;
import cofh.thermal.core.inventory.container.device.DeviceHiveExtractorContainer;
import cofh.thermal.core.util.managers.device.HiveExtractorManager;
import cofh.thermal.lib.block.entity.DeviceBlockEntity;
import cofh.thermal.lib.common.ThermalAugmentRules;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class DeviceHiveExtractorTile
extends DeviceBlockEntity {
    public static final BiPredicate<ItemStack, List<ItemStack>> AUG_VALIDATOR = ThermalAugmentRules.createAllowValidator("Upgrade", "Fluid");
    protected ItemStorageCoFH outputSlot = new ItemStorageCoFH();
    protected FluidStorageCoFH outputTank = new FluidStorageCoFH(8000);

    public DeviceHiveExtractorTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TCoreTileEntities.DEVICE_HIVE_EXTRACTOR_TILE.get(), pos, state);
        this.inventory.addSlot(this.outputSlot, StorageGroup.OUTPUT);
        this.tankInv.addTank(this.outputTank, StorageGroup.OUTPUT);
        this.addAugmentSlots(ThermalCoreConfig.deviceAugments);
        this.initHandlers();
    }

    @Override
    protected void updateActiveState() {
        super.updateActiveState();
        if (this.isActive) {
            this.extractProducts(this.f_58858_.m_7494_());
        }
    }

    @Override
    protected boolean isValid() {
        return this.f_58857_ != null && this.f_58857_.m_8055_(this.f_58858_.m_7494_()).m_61138_((Property)BeehiveBlock.f_49564_);
    }

    protected void extractProducts(BlockPos above) {
        if (this.f_58857_ == null) {
            return;
        }
        BlockState hive = this.f_58857_.m_8055_(above);
        if (hive.m_61138_((Property)BeehiveBlock.f_49564_) && BeehiveBlockEntity.m_58752_((BlockState)hive) >= 5) {
            ItemStack comb = HiveExtractorManager.instance().getItem(hive);
            FluidStack honey = HiveExtractorManager.instance().getFluid(hive);
            this.outputSlot.insertItem(0, comb, false);
            this.outputTank.fill(honey, IFluidHandler.FluidAction.EXECUTE);
            this.f_58857_.m_7731_(above, (BlockState)hive.m_61124_((Property)BeehiveBlock.f_49564_, (Comparable)Integer.valueOf(0)), 3);
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new DeviceHiveExtractorContainer(i, this.f_58857_, this.f_58858_, inventory, player);
    }

    @Override
    protected Predicate<ItemStack> augValidator() {
        return item -> AugmentDataHelper.hasAugmentData((ItemStack)item) && AUG_VALIDATOR.test((ItemStack)item, this.getAugmentsAsList());
    }
}

